******************************************************
* THE FAIRLY FAST MAIN POLYGON ROUTINE FOR THE GAME  *
******************************************************

DRAW_3D_SQUARE:
	MOVE.W	(4*13)+2(A1),D3		CHECK LEFT TRIANGLE
	CMP.W	2(A1),D3
	BLT.S	.HIDDEN1
.IS_VIS1
	MOVE.W	(4*14)+2(A1),D3		CHECK RIGHT TRIANGLE
	CMP.W	6(A1),D3
	BGE	.DO_4_SIDED

	MOVEM.W	4(A1),D0-D1		DO A PROPER CHECK
	MOVEM.W	4*13(A1),D2-D5
	SUB.W	D0,D4			FOR FIRST TRIANGLE
	SUB.W	D1,D5
	SUB.W	D0,D2
	SUB.W	D1,D3
	MULS	D4,D3
	MULS	D5,D2
	SUB.L	D2,D3
	BPL	.DO_4_SIDED		

*OK SO WE JUST DRAW THE FIRST TRIANGLE

	MOVE.L	(A1),D1
	MOVE.L	4(A1),D2
	MOVE.L	4*13(A1),D3
	MOVEM.L	D1-D3,-(A0)
	MOVEM.L	D1-D3,-(A0)
	MOVEQ	#0,D0			GET COLOR
	MOVE.B	-1(A2),D0

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_3_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES+32(PC),A0
.FORGET_IT4:
	RTS

.HIDDEN1
	MOVEM.W	(A1),D0-D3		PROPER HIDDEN CHECK
	MOVE.W	4*13(A1),D4
	MOVE.W	(4*13)+2(A1),D5
	SUB.W	D0,D2			FOR FIRST TRIANGLE
	SUB.W	D1,D3
	SUB.W	D0,D4
	SUB.W	D1,D5
	MULS	D2,D5
	MULS	D3,D4
	SUB.L	D4,D5
	BPL.S	.IS_VIS1

	MOVE.W	(4*14)+2(A1),D2

	CMP.W	6(A1),D2
	BLT.S	.HIDDEN2
.IS_VIS2:
	MOVE.L	4*14(A1),D2
	MOVE.L	4*13(A1),D3
	MOVE.L	4(A1),D1		GET TRIANGLE
	MOVEM.L	D1-D3,-(A0)
	MOVEM.L	D1-D3,-(A0)

	MOVEQ	#0,D0			*GET COLOR
	MOVE.B	-1(A2),D0

*DRAW THE SECOND TRIANGLE ONLY	

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR.S	POLY_3_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES+32(PC),A0
	RTS

.HIDDEN2
	MOVEM.W	4(A1),D0-D1		DO A PROPER CHECK
	MOVEM.W	4*13(A1),D2-D5
	SUB.W	D0,D4			FOR FIRST TRIANGLE
	SUB.W	D1,D5
	SUB.W	D0,D2
	SUB.W	D1,D3
	MULS	D4,D3
	MULS	D5,D2
	SUB.L	D2,D3
	BPL.S	.IS_VIS2
*WHAT A WASTE OF TIME. NO TRIANGLES DRAWN
	RTS

* SO WE TRY AND DRAW A 4 SIDED TRIANGLE
* THIS IS NOT ALWAYS POSSIBLE IF THERE IS AN ANGLE OF MORE THAN 180 DEGS
* IN THE POLYGON. SO A SPECIAL ROUTINE THAT CHECKS FOR THIS INSTANCE
* IS USED, BUT THE VAST MAJORITY OF POLYGONS WITH 4 SIDES CAN BE DRAWN
* SO WE DON'T LOSE ANYTHING BY TRYING!!

.DO_4_SIDED:
	MOVE.L	(A1),D1
	MOVE.L	4(A1),D2
	MOVE.L	4*14(A1),D3
	MOVE.L	4*13(A1),D4
	MOVEM.L	D1-D4,-(A0)
	MOVEM.L	D1-D4,-(A0)
	MOVEQ	#0,D0			*GET COLOR
	MOVE.B	-1(A2),D0

	MOVE.L	A1,-(A7)
	MOVE.L	A2,-(A7)
	BSR	POLY_4_SIDED		EXECUTE POLY DRAW
	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES+32(PC),A0
.OUT1
	RTS

***********************************************
* NEW POLYGON ROUTINES. ONE FOR 3 VERTICES AND*
* ONE FOR 4 VERTICES. OPTIMIZED FOR EACH.     *
***********************************************

*D0 = COLOR
*A0 = ADDRESS OF SURFACES

POLY_3_SIDED:
COL_MOD1:
	LEA 	COL0,A2			*D0 CONTAINS COLOR
	MOVE.B	D0,LAST_COLOR
	LSL.W	#4,D0
	MOVEM.L (A2,D0.W),D1/D7/A5
	LEA	MOD2+2(PC),A2
	MOVE.L	D1,(A2)
	MOVE.L	D1,MOD4-MOD2(A2)
	MOVE.L	D7,MOD_D7-MOD2(A2)
	MOVE.L	A5,MOD_A5-MOD2(A2)
POLY_3_SIDED_AC:
	MOVE.L	(A0)+,D4
	MOVE.L	D4,D1
	MOVE.L	A0,A4

	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.2
	MOVE.W 	D3,D4
	BRA.S	.22
.2	MOVE.L	A0,A4
	MOVE.W	D3,D1
.22
	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.3
	MOVE.W 	D3,D4
	BRA.S	.33
.3
	CMP.W	D3,D1
	BLE.S	.33
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.33
	LEA	8(A4),A3
	SUBQ.L	#4,A4

	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ 	ABORT_POLY		*0 LINES TO DRAW!!

.FLAT_CHECK:
	MOVE.L 	(A4)+,D0
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2
	ADDQ.L 	#4,A4			*YEP IT IS 
.FLAT_CHECK2:
	CMP.W 	-2(A3),D0
	BNE.S 	.FLAT_DONE
	SUBQ.L 	#4,A3
.FLAT_DONE:
	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS

	MOVE.W	D0,BIT_MASK
	LSL.W	#5,D0
	ADD.W	D0,A6
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D0,A6

	LEA	POLYGON_IMG(PC),A0
	LEA	GRAD_TABLE+640(PC),A1
	LEA	.CALC_TABLEB3(PC),A2
	MOVE.W	D4,D6
.LEFT_AGAIN:
	MOVE.L 	(A3),D3
	MOVE.W 	-(A3),D5
	SUB.W 	D3,D5
	CLR.W 	D3
	MOVE.W 	D5,D0
	MOVE.W 	-(A3),D1
	SUB.W 	4(A3),D1
	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1
.MAKE_LEFT_COORDINATES:
	SUB.W	D5,D6
	SWAP	D1
	SWAP	D3
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLEB3:

	TST.W	D6
	BNE	.LEFT_AGAIN
	
*DO RIGHT HAND OF POLYGON

.DO_RIGHT:
	LEA	POLYGON_IMG+400(PC),A0
	MOVE.W	D4,D6
	LEA	CALC_TABLEB2(PC),A2
	
RIGHT_AGAIN1:
	MOVE.L 	-4(A4),D3
	MOVE.W  (A4)+,D1
	MOVE.W  (A4)+,D5
	SUB.W   D3,D5
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -8(A4),D1

	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1
.MAKE_RIGHT_COORDINATES1:
	SUB.W	D5,D6
	SWAP	D1
	SWAP	D3
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
CALC_TABLEB2:

	TST.W	D6
	BNE	RIGHT_AGAIN1
MOD2:	JMP	DRAW_POLYGON1A

*D0 = COLOR
*A0 = ADDRESS OF SURFACES

POLY_4_SIDED:
	CMP.B	LAST_COLOR(PC),D0
	BEQ.S	NO_COLOR_CHANGE
COL_MOD2:
	LEA 	COL0,A2			*D0 CONTAINS COLOR
	MOVE.B	D0,LAST_COLOR
	LSL.W	#4,D0
	MOVEM.L (A2,D0.W),D1/D7/A5
	LEA	MOD2+2(PC),A2
	MOVE.L	D1,(A2)
	MOVE.L	D1,MOD4-MOD2(A2)
	MOVE.L	D7,MOD_D7-MOD2(A2)
	MOVE.L	A5,MOD_A5-MOD2(A2)
	BRA.S	NOT_AGAINXX
NO_COLOR_CHANGE:
MOD_D7	MOVE.L	#1234,D7
MOD_A5	MOVE.L	#1234,A5
NOT_AGAINXX:
	MOVE.L	(A0)+,D4
	MOVE.L	D4,D1
	MOVE.L	A0,A4

	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.2
	MOVE.W 	D3,D4
	BRA.S	.22
.2	MOVE.L	A0,A4
	MOVE.W	D3,D1
.22
	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.3
	MOVE.W 	D3,D4
	BRA.S	.33
.3
	CMP.W	D3,D1
	BLE.S	.33
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.33
	MOVE.L 	(A0)+,D3
	CMP.W 	D3,D4
	BGE.S	.4
	MOVE.W 	D3,D4
	BRA.S	.44
.4
	CMP.W	D3,D1
	BLE.S	.44
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.44

	LEA	12(A4),A3
	SUBQ.L	#4,A4

	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ 	ABORT_POLY		*0 LINES TO DRAW!!

.FLAT_CHECK:
	MOVE.L 	(A4)+,D0
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2
	ADDQ.L 	#4,A4			*YEP IT IS 
.FLAT_CHECK2:
	CMP.W 	-2(A3),D0
	BNE.S 	.FLAT_DONE
	SUBQ.L 	#4,A3
.FLAT_DONE:

	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS
	MOVE.W	D0,BIT_MASK
	LSL.W	#5,D0
	ADD.W	D0,A6
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D0,A6

	LEA	POLYGON_IMG(PC),A0
	LEA	GRAD_TABLE+640(PC),A1
	LEA	.CALC_TABLE(PC),A2
	MOVE.W	D4,D6
.LEFT_AGAIN:
	MOVE.L 	(A3),D3
	MOVE.W 	-(A3),D5
	SUB.W 	D3,D5
	BLE	ABORT_POLYGON2			*ILLEGAL POLYGON?
	CLR.W 	D3
	MOVE.W 	D5,D0
	MOVE.W 	-(A3),D1
	SUB.W 	4(A3),D1
	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1
.MAKE_LEFT_COORDINATES:
	SUB.W	D5,D6
	SWAP	D1
	SWAP	D3
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLE:
	TST.W	D6
	BNE	.LEFT_AGAIN
	
*DO RIGHT HAND OF POLYGON
.DO_RIGHT:
	LEA	POLYGON_IMG+400(PC),A0
	MOVE.W	D4,D6
	LEA	CALC_TABLEB(PC),A2
	
RIGHT_AGAIN2:
	MOVE.L 	-4(A4),D3
	MOVE.W  (A4)+,D1
	MOVE.W  (A4)+,D5
	SUB.W   D3,D5
	BLE	ABORT_POLYGON2			ILLEGAL POLYGON?
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -8(A4),D1
	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1
.MAKE_RIGHT_COORDINATES2:
	SUB.W	D5,D6
	SWAP	D1
	SWAP	D3
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
CALC_TABLEB:
	TST.W	D6
	BNE	RIGHT_AGAIN2
MOD4:	JMP	DRAW_POLYGON1A

****************************************************
* NOT ALWAYS POSSIBLE TO DRAW A 4 SIDED POLYGON    *
* THIS ROUTINE CATCHES 4 SIDE ERRORS AND INSTEAD   *
* IT DRAWS 2 3 SIDED POLYGONS                      *
****************************************************

ABORT_POLYGON2:
	ADDQ.L	#4,SP			*ADJUST THE STACK A TO TAKE ACCOUNT OF BSR
	LEA	POLY_SURFACES(PC),A0
	MOVEM.L	4(A0),D1-D3
	MOVEM.L	D1-D3,24(A0)
	MOVEM.L	D1-D3,36(A0)
	MOVE.L	12(A0),8(A0)			
	MOVEM.L	(A0),D1-D3
	MOVEM.L	D1-D3,12(A0)
	BSR	POLY_3_SIDED_AC		EXECUTE POLY DRAW

	LEA	POLY_SURFACES+24(PC),A0
	BSR	POLY_3_SIDED_AC		EXECUTE POLY DRAW

	MOVE.L	(A7)+,A2
	MOVE.L	(A7)+,A1
	LEA	POLY_SURFACES+32(PC),A0
.FORGET_IT2
	RTS

***************************************
* BITS FOR THE SELF MODIFYING COLOR   *
* ROUTINES                            *
***************************************

LAST_COLOR:	DC.B	0,0

COL0
	DC.L	DRAW_POLYGON1A
	DC.L 	$FFFF0000,$00000000,0
	DC.L	DRAW_POLYGON2A
	DC.L 	$0000FFFF,$00000000,0
	DC.L	DRAW_POLYGON3A
	DC.L 	$FFFFFFFF,$00000000,0
	DC.L	DRAW_POLYGON4A
	DC.L 	$00000000,$FFFF0000,0
	DC.L	DRAW_POLYGON5A
	DC.L 	$FFFF0000,$FFFF0000,0
	DC.L	DRAW_POLYGON6A
	DC.L 	$0000FFFF,$FFFF0000,0
	DC.L	DRAW_POLYGON7A
	DC.L 	$FFFFFFFF,$FFFF0000,0
	DC.L	DRAW_POLYGON8A
	DC.L 	$00000000,$0000FFFF,0
	DC.L	DRAW_POLYGON9A
 	DC.L 	$FFFF0000,$0000FFFF,0
	DC.L	DRAW_POLYGON10A
	DC.L	$0000FFFF,$0000FFFF,0
	DC.L	DRAW_POLYGON11A
	DC.L 	$FFFFFFFF,$0000FFFF,0
	DC.L	DRAW_POLYGON12A
	DC.L 	$00000000,$FFFFFFFF,0
	DC.L	DRAW_POLYGON13A
	DC.L 	$FFFF0000,$FFFFFFFF,0
	DC.L	DRAW_POLYGON14A
	DC.L	$0000FFFF,$FFFFFFFF,0
	DC.L	DRAW_POLYGON15A
	DC.L 	$FFFFFFFF,$FFFFFFFF,0
	DC.L	DRAW_POLYGON16A
	DC.L 	$0000FFFF,$00000000,0
	DC.L	DRAW_POLYGON17A
	DC.L 	$FFFFFFFF,$00000000,0

COL1
	DC.L	DRAW_POLYGON1B
	DC.L 	$FFFF0000,$00000000,0
	DC.L	DRAW_POLYGON2B
	DC.L 	$0000FFFF,$00000000,0
	DC.L	DRAW_POLYGON3B
	DC.L 	$FFFFFFFF,$00000000,0
	DC.L	DRAW_POLYGON4B
	DC.L 	$00000000,$FFFF0000,0
	DC.L	DRAW_POLYGON5B
	DC.L 	$FFFF0000,$FFFF0000,0
	DC.L	DRAW_POLYGON6B
	DC.L 	$0000FFFF,$FFFF0000,0
	DC.L	DRAW_POLYGON7B
	DC.L 	$FFFFFFFF,$FFFF0000,0
	DC.L	DRAW_POLYGON8B
	DC.L 	$00000000,$0000FFFF,0
	DC.L	DRAW_POLYGON9B
 	DC.L 	$FFFF0000,$0000FFFF,0
	DC.L	DRAW_POLYGON10B
	DC.L	$0000FFFF,$0000FFFF,0
	DC.L	DRAW_POLYGON11B
	DC.L 	$FFFFFFFF,$0000FFFF,0
	DC.L	DRAW_POLYGON12B
	DC.L 	$00000000,$FFFFFFFF,0
	DC.L	DRAW_POLYGON13B
	DC.L 	$FFFF0000,$FFFFFFFF,0
	DC.L	DRAW_POLYGON14B
	DC.L	$0000FFFF,$FFFFFFFF,0
	DC.L	DRAW_POLYGON15B
	DC.L 	$FFFFFFFF,$FFFFFFFF,0
	DC.L	DRAW_POLYGON16A
	DC.L 	$0000FFFF,$00000000,0
	DC.L	DRAW_POLYGON17A
	DC.L 	$FFFFFFFF,$00000000,0

COL2
	DC.L	DRAW_POLYGON1C
	DC.L 	$FFFF0000,$00000000,0
	DC.L	DRAW_POLYGON2C
	DC.L 	$0000FFFF,$00000000,0
	DC.L	DRAW_POLYGON3C
	DC.L 	$FFFFFFFF,$00000000,0
	DC.L	DRAW_POLYGON4C
	DC.L 	$00000000,$FFFF0000,0
	DC.L	DRAW_POLYGON5C
	DC.L 	$FFFF0000,$FFFF0000,0
	DC.L	DRAW_POLYGON6C
	DC.L 	$0000FFFF,$FFFF0000,0
	DC.L	DRAW_POLYGON7C
	DC.L 	$FFFFFFFF,$FFFF0000,0
	DC.L	DRAW_POLYGON8C
	DC.L 	$00000000,$0000FFFF,0
	DC.L	DRAW_POLYGON9C
 	DC.L 	$FFFF0000,$0000FFFF,0
	DC.L	DRAW_POLYGON10C
	DC.L	$0000FFFF,$0000FFFF,0
	DC.L	DRAW_POLYGON11C
	DC.L 	$FFFFFFFF,$0000FFFF,0
	DC.L	DRAW_POLYGON12C
	DC.L 	$00000000,$FFFFFFFF,0
	DC.L	DRAW_POLYGON13C
	DC.L 	$FFFF0000,$FFFFFFFF,0
	DC.L	DRAW_POLYGON14C
	DC.L	$0000FFFF,$FFFFFFFF,0
	DC.L	DRAW_POLYGON15C
	DC.L 	$FFFFFFFF,$FFFFFFFF,0
	DC.L	DRAW_POLYGON16B
	DC.L 	$0000FFFF,$00000000,0
	DC.L	DRAW_POLYGON17B
	DC.L 	$FFFFFFFF,$00000000,0

POLY_SURFACES:	DS.W	12*16

POLYGON_COLOR:	MACRO

DRAW_POLYGON\1A:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVEQ	#15,D3
	MOVEQ	#32,D6
	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+
	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

DRAW_POLYGON\1B:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVEQ	#15,D3
	MOVEQ	#32,D6
	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+
	SUB.W 	D6,D0		
	BLT.S	.FILL_TOWER
	MOVE.L 	D7,(A0)+
	MOVE.L 	A5,(A0)+		
.FILL_TOWER
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+
	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

DRAW_POLYGON\1C:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVEQ	#15,D3
	MOVEQ	#32,D6
	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+
	SUB.W 	D6,D0		
	BLT.S	.FILL_TOWER
	CMP.W	D3,D0
	BLE.S	.FILL_TOWER-4
	MOVE.L 	D7,(A0)+
	MOVE.L 	A5,(A0)+		
	MOVE.L 	D7,(A0)+
	MOVE.L 	A5,(A0)+		
.FILL_TOWER
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2
	\2.W	D\6,(A0)+
	\3.W	D\7,(A0)+
	\4.W	D\8,(A0)+
	\5.W	D\9,(A0)+
	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS
	ENDM

LEFT_MASKS:
	DC.W	%1111111111111111
	DC.W	%0111111111111111
	DC.W	%0011111111111111
	DC.W	%0001111111111111
	DC.W	%0000111111111111
	DC.W	%0000011111111111
	DC.W	%0000001111111111
	DC.W	%0000000111111111
	DC.W	%0000000011111111
	DC.W	%0000000001111111
	DC.W	%0000000000111111
	DC.W	%0000000000011111
	DC.W	%0000000000001111
	DC.W	%0000000000000111
	DC.W	%0000000000000011
	DC.W	%0000000000000001

	DS.W	16
	DC.W	%1000000000000000
	DC.W	%1100000000000000
	DC.W	%1110000000000000
	DC.W	%1111000000000000
	DC.W	%1111100000000000
	DC.W	%1111110000000000
	DC.W	%1111111000000000
	DC.W	%1111111100000000
	DC.W	%1111111110000000
	DC.W	%1111111111000000
	DC.W	%1111111111100000
	DC.W	%1111111111110000
	DC.W	%1111111111111000
	DC.W	%1111111111111100
	DC.W	%1111111111111110
	DC.W	%1111111111111111
RIGHT_MASKS
	REPT	4
	DC.W	%1000000000000000
	DC.W	%1100000000000000
	DC.W	%1110000000000000
	DC.W	%1111000000000000
	DC.W	%1111100000000000
	DC.W	%1111110000000000
	DC.W	%1111111000000000
	DC.W	%1111111100000000
	DC.W	%1111111110000000
	DC.W	%1111111111000000
	DC.W	%1111111111100000
	DC.W	%1111111111110000
	DC.W	%1111111111111000
	DC.W	%1111111111111100
	DC.W	%1111111111111110
	DC.W	%1111111111111111
	ENDR

	POLYGON_COLOR	1,OR,AND,AND,AND,1,2,2,2
	POLYGON_COLOR	2,AND,OR,AND,AND,2,1,2,2
	POLYGON_COLOR	3,OR,OR,AND,AND,1,1,2,2
	POLYGON_COLOR	4,AND,AND,OR,AND,2,2,1,2
	POLYGON_COLOR	5,OR,AND,OR,AND,1,2,1,2
	POLYGON_COLOR	6,AND,OR,OR,AND,2,1,1,2
	POLYGON_COLOR	7,OR,OR,OR,AND,1,1,1,2
	POLYGON_COLOR	8,AND,AND,AND,OR,2,2,2,1
	POLYGON_COLOR	9,OR,AND,AND,OR,1,2,2,1
	POLYGON_COLOR	10,AND,OR,AND,OR,2,1,2,1
	POLYGON_COLOR	11,OR,OR,AND,OR,1,1,2,1
	POLYGON_COLOR	12,AND,AND,OR,OR,2,2,1,1
	POLYGON_COLOR	13,OR,AND,OR,OR,1,2,1,1
	POLYGON_COLOR	14,AND,OR,OR,OR,2,1,1,1
	POLYGON_COLOR	15,OR,OR,OR,OR,1,1,1,1

BIT_MASK:	DC.W	0

DRAW_POLYGON16A:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVE.L	A5,D6
	MOVE.W	BIT_MASK(PC),D6
	BTST	#0,D6
	BEQ.S	.1
	MOVE.W	#%1010101010101010,D6
	BRA.S	.2
.1	MOVE.W	#%0101010101010101,D6
.2
	MOVEQ	#15,D3
	MOVEQ	#32,D5

	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	NOT.W	D6
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	SUB.W 	D5,D0
	BLT.S	.FILL_TOWER
	MOVE.L 	D7,(A0)+
	MOVE.L	D6,(A0)+
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2

	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

DRAW_POLYGON16B:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVE.L	A5,D6
	MOVE.W	BIT_MASK(PC),D6
	BTST	#0,D6
	BEQ.S	.1
	MOVE.W	#%1010101010101010,D6
	BRA.S	.2
.1	MOVE.W	#%0101010101010101,D6
.2
	MOVEQ	#15,D3
	MOVEQ	#32,D5

	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	NOT.W	D6
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	SUB.W 	D5,D0
	BLT.S	.FILL_TOWER
	CMP.W	D3,D0
	BLE.S	.FILL_TOWER-4

	MOVE.L 	D7,(A0)+
	MOVE.L	D6,(A0)+
	MOVE.L 	D7,(A0)+
	MOVE.L	D6,(A0)+
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2

	AND.W	D2,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

DRAW_POLYGON17A:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVE.L	A5,D6
	MOVE.W	BIT_MASK(PC),D6
	BTST	#0,D6
	BEQ.S	.1
	MOVE.W	#%1010101010101010,D6
	BRA.S	.2
.1	MOVE.W	#%0101010101010101,D6
.2
	MOVEQ	#15,D3
	MOVEQ	#32,D5

	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	NOT.W	D6
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	SUB.W 	D5,D0
	BLT.S	.FILL_TOWER
	MOVE.L 	D7,(A0)+
	MOVE.L	D6,(A0)+
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2

	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

DRAW_POLYGON17B:
	LEA	POLYGON_IMG(PC),A1
	LEA	POLYGON_IMG+400(PC),A2
	LEA	LEFT_MASKS(PC),A3
	LEA	RIGHT_MASKS(PC),A4
	MOVE.L	A5,D6
	MOVE.W	BIT_MASK(PC),D6
	BTST	#0,D6
	BEQ.S	.1
	MOVE.W	#%1010101010101010,D6
	BRA.S	.2
.1	MOVE.W	#%0101010101010101,D6
.2
	MOVEQ	#15,D3
	MOVEQ	#32,D5

	SUBQ.W	#1,D4
.POLYFILL_LOOP:
	NOT.W	D6
	MOVE.W	(A1)+,D0
	MOVE.W	(A2)+,D1

	MOVE.W 	D0,D2			*GET LEFT X TWICE
	SUB.W 	D0,D1			*GET RIGHT X
	AND.W 	D3,D0
	SUB.W	D0,D2
	LSR.W 	#1,D2			
	LEA	(A6,D2.W),A0		*GET SCREEN ADDRESS FOR LINE

	MOVE.W	D0,D2
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D2

	ADD.W 	D1,D0			*CHECK TO SEE IF ON MORE THAN
	CMP.W	D3,D0
	BGT.S 	.MULTI_CHUNK		*YEP IT IS
	ADD.W	D0,D0
	AND.W 	-32(A4,D0.W),D2			
	MOVE.W 	D2,D1
	NOT.W 	D2
	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS

.MULTI_CHUNK
	MOVE.W 	D2,D1			split case			
	NOT.W	D2

	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	SUB.W 	D5,D0
	BLT.S	.FILL_TOWER
	CMP.W	D3,D0
	BLE.S	.FILL_TOWER-4

	MOVE.L 	D7,(A0)+
	MOVE.L	D6,(A0)+
	MOVE.L 	D7,(A0)+
	MOVE.L	D6,(A0)+
.FILL_TOWER:
	ADD.W 	D0,D0
	MOVE.W 	(A4,D0.W),D1 
	MOVE.W 	D1,D2
	NOT.W 	D2

	OR.W	D1,(A0)+
	OR.W	D1,(A0)+
	AND.W	D2,(A0)+
	AND.W	D6,D1
	AND.W	D2,(A0)
	OR.W	D1,(A0)+

	LEA 	160(A6),A6
	DBF	D4,.POLYFILL_LOOP
	RTS
